// STACKS1.h: interface for the STACKS class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STACKS1_H__E365F34F_5C20_422E_913A_DD8713B65A5A__INCLUDED_)
#define AFX_STACKS1_H__E365F34F_5C20_422E_913A_DD8713B65A5A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

template <class DATATYPE>

//-------------------------------- S T A C K  C L A S S --------------------------------
//------------------------------- (array implementation) -------------------------------

class STACK
{
	private:

		DATATYPE *data;				//Template type Data
		int size;					
		int maximum_size;			//maximum size of the size

	public:

		STACK();					//Default Constructor
		STACK(int num);				//One Argument Constructor

		void Push(DATATYPE&);		//Push the value on the stack
		DATATYPE& Pop();			//Pop a value from the stack
		DATATYPE& Peek();			//Peek sees the top value of the stack

		int Get_Size();				//Gives the latest sizr of the stack
		void ReAllocate(int);		//ReAllocates the size of the array used by the stack

		bool isEmpty();				//Checks that if the stack is empty or not
		bool isFull();				//Checks that if the stack is Full or not
		~STACK();					//Destructor
};

#endif // !defined(AFX_STACKS1_H__E365F34F_5C20_422E_913A_DD8713B65A5A__INCLUDED_)
